/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.init;

import morph.avaritia.client.AvaritiaShaders;
import morph.avaritia.client.AvaritiaTextures;
import morph.avaritia.client.gui.ExtremeCraftingTableScreen;
import morph.avaritia.client.gui.NeutronCollectorScreen;
import morph.avaritia.client.gui.NeutroniumCompressorScreen;
import morph.avaritia.client.model.CosmicModelLoader;
import morph.avaritia.client.model.HaloItemModelLoader;
import morph.avaritia.client.render.entity.GapingVoidEntityRenderer;
import morph.avaritia.client.render.entity.InfinityArrowRenderer;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.item.tools.InfinityBowItem;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init() {
        LOCK.lock();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ClientInit::clientSetupEvent);
        modEventBus.addListener(ClientInit::onModelRegistryEvent);
        modEventBus.addListener(ClientInit::registerRenderers);
        AvaritiaTextures.init();
        AvaritiaShaders.init();
    }

    private static void clientSetupEvent(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)AvaritiaModContent.EXTREME_CRAFTING_MENU.get()), ExtremeCraftingTableScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)AvaritiaModContent.COMPRESSOR_MENU.get()), NeutroniumCompressorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)AvaritiaModContent.NEUTRON_COLLECTOR_MENU.get()), NeutronCollectorScreen::new);
        ClientInit.initItemProperties();
    }

    private static void onModelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("avaritia", "halo"), (IModelLoader)new HaloItemModelLoader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)CosmicModelLoader.ID, (IModelLoader)new CosmicModelLoader());
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AvaritiaModContent.INFINITY_ARROW_ENTITY.get(), InfinityArrowRenderer::new);
        event.registerEntityRenderer((EntityType)AvaritiaModContent.ENDEST_PEARL_ENTITY_TYPE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)AvaritiaModContent.GAPING_VOID_ENTITY_TYPE.get(), GapingVoidEntityRenderer::new);
    }

    private static void initItemProperties() {
        ItemProperties.register((Item)((Item)AvaritiaModContent.INFINITY_BOW.get()), (ResourceLocation)new ResourceLocation("avaritia", "pull"), (stack, level, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / (float)InfinityBowItem.DRAW_TIME;
        });
        ItemProperties.register((Item)((Item)AvaritiaModContent.INFINITY_BOW.get()), (ResourceLocation)new ResourceLocation("avaritia", "pulling"), (stack, level, entity, i) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)AvaritiaModContent.INFINITY_PICKAXE.get()), (ResourceLocation)new ResourceLocation("avaritia", "hammer"), (stack, level, entity, i) -> stack.m_41782_() && stack.m_41784_().m_128471_("hammer") ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)AvaritiaModContent.INFINITY_SHOVEL.get()), (ResourceLocation)new ResourceLocation("avaritia", "destroyer"), (stack, level, entity, i) -> stack.m_41782_() && stack.m_41784_().m_128471_("destroyer") ? 1.0f : 0.0f);
    }
}

